/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.Reconfigurable;

public abstract class Device
implements Reconfigurable {
    private int waitCycles = 0;
    private boolean run = true;

    public void addWaitCycles(int wait) {
        this.waitCycles += wait;
    }

    public void setWaitCycles(int wait) {
        this.waitCycles = wait;
    }

    public void doTick() {
        if (!this.run) {
            return;
        }
        if (this.waitCycles > 0) {
            --this.waitCycles;
            return;
        }
        this.tick();
    }

    public boolean isRunning() {
        return this.run;
    }

    public synchronized void setRun(boolean run) {
        this.run = run;
    }

    protected abstract String getDeviceName();

    @Override
    public String getName() {
        return this.getDeviceName();
    }

    public abstract void tick();

    public void suspend() {
        this.setRun(false);
    }

    public void resume() {
        this.setRun(true);
    }

    public abstract void attach();

    public abstract void detach();
}

